/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

public class CodePanelPosition {
    private int visible_lines;
    private int current_position;
    private int current_range;
    private int selected_address;

    public CodePanelPosition(int visible_lines, int current_position, int current_range) {
        this.visible_lines = visible_lines;
        this.current_position = current_position;
        this.current_range = current_range;
        this.selected_address = -1;
    }

    public int getVisibleLines() {
        return this.visible_lines;
    }

    public void setVisibleLines(int visible_lines) {
        this.visible_lines = visible_lines;
    }

    public int getCurrentPosition() {
        return this.current_position;
    }

    public void setCurrentPosition(int desired_position) {
        this.current_position = Math.min(Math.max(0, desired_position), this.getCurrentRange() - this.getVisibleLines());
    }

    public int getCurrentRange() {
        return this.current_range;
    }

    public void setCurrentRange(int current_range) {
        this.current_range = current_range;
    }

    public int getSelectedAddress() {
        return this.selected_address;
    }

    public void setSelectedAddress(int selectedLine) {
        this.selected_address = selectedLine;
    }

    boolean isVisibleLine(int index) {
        return this.getCurrentPosition() <= index && index < this.getCurrentPosition() + this.getVisibleLines();
    }

    boolean isSelectedAddress(int address) {
        return address == this.selected_address;
    }
}

